//: Playground - noun: a place where people can play

import UIKit

class Animal {
    /* W podejściu zorientowanym obiektowo podklasa nie może przypisywać
       lub zmieniać wartości stałej zdefiniowanej w superklasie. Aby przedstawione
       tutaj rozwiązanie działało, podklasa musi być zdefiniowana w tym samym
       fizycznym pliku, w którym znajduje się superklasa. */
    fileprivate var landAnimal = false
    fileprivate var landAttack = false
    fileprivate var landMovement = false
    
    fileprivate var seaAnimal = false
    fileprivate var seaAttack = false
    fileprivate var seaMovement = false
    
    fileprivate var airAnimal = false
    fileprivate var airAttack = false
    fileprivate var airMovement = false
    
    fileprivate var hitPoints = 0
    
    init() {
        landAnimal = false
        landAttack = false
        landMovement = false
        
        airAnimal = false
        airAttack = false
        airMovement = false
        
        seaAnimal = false
        seaAttack = false
        seaMovement = false
        hitPoints = 0
    }
    
    func isLandAnimal() -> Bool { return landAnimal }
    func canLandAttack() -> Bool { return landAttack }
    func canLandMove() -> Bool { return landMovement }
    
    func isSeaAnimal() -> Bool { return seaAnimal }
    func canSeaAttack() -> Bool { return seaAttack }
    func canSeaMove() -> Bool { return seaMovement }
    
    func isAirAnimal() -> Bool { return airAnimal }
    func canAirAttack() -> Bool { return airAttack }
    func canAirMove() -> Bool { return airMovement }
    
    func doLandAttack() {}
    func doLandMovement() {}
    
    func doSeaAttack() {}
    func doSeaMovement() {}
    
    func doAirAttack() {}
    func doAirMovement() {}
    
    func takeHit(amount: Int) { hitPoints -= amount }
    func hitPointsRemaining() -> Int { return hitPoints }
    func isAlive() -> Bool { return hitPoints > 0 ? true : false }
    
}





class Lion: Animal {
    
    override init() {
        super.init()
        landAnimal = true
        landAttack = true
        landMovement = true
        hitPoints = 20
    }
    
    override func doLandAttack() { print("Lew atakuje.") }
    override func doLandMovement() { print("Lew porusza się.") }
}

class Alligator: Animal {
    
    override init() {
        super.init()
        landAnimal = true
        landAttack = true
        landMovement = true
        
        seaAnimal = true
        seaAttack = true
        seaMovement = true
        hitPoints = 35
    }
    
    override func doLandAttack() { print("Aligator atakuje na lądzie.") }
    override func doLandMovement() { print("Aligator porusza się na lądzie.") }
    override func doSeaAttack() { print("Aligator atakuje w wodzie.") }
    override func doSeaMovement() { print("Aligator porusza się w wodzie.") }
    
}


var animals = [Animal]()

var an1 = Alligator()
var an2 = Alligator()
var an3 = Lion()

animals.append(an1)
animals.append(an2)
animals.append(an3)


for (index, animal) in animals.enumerated() {
    if animal.isAirAnimal() {
        print("Zwierzę o indeksie \(index) to powietrzne")
    }
    if animal.isLandAnimal() {
        print("Zwierzę o indeksie \(index) to lądowe")
    }
    if animal.isSeaAnimal() {
        print("Zwierzę o indeksie \(index) to morskie")
    }
}
